//******************************************************************************
//  E-154.
//         
//           .
//          100 .
//******************************************************************************
#include <stdio.h>
#include <conio.h>
#include "Lusbapi.h"

#define CHANNELS_QUANTITY			(0x4)

//    
void AbortProgram(char *ErrorString, bool AbortionFlag = true);
//      
DWORD WINAPI ServiceReadThread(PVOID /*Context*/);
//       
BOOL WaitingForRequestCompleted(OVERLAPPED *ReadOv);
//     
void ShowThreadErrorMessage(void);

//   -  
//   (  )
const WORD MaxVirtualSoltsQuantity = 127;

//  
HANDLE hFile;

//    
HANDLE hReadThread;
DWORD ReadTid;

//  
DWORD DllVersion;
//    
ILE154 *pModule;
//  
HANDLE ModuleHandle;
//  
char ModuleName[7];
//    USB
BYTE UsbSpeed;
//      
MODULE_DESCRIPTION_E154 ModuleDescription;
//     
ADC_PARS_E154 ap;

// -   ( 32)  . ReadData()
DWORD DataStep = 64*1024;
//   NDataBlock   DataStep   
const WORD NDataBlock = 80;
//     
const double AdcRate = 5000.0;
//  
SHORT *ReadBuffer;

//      
bool IsReadThreadComplete, IsThreadStopping;

//      
WORD ReadThreadErrorNumber;

//  -
DWORD Counter = 0x0, OldCounter = 0xFFFFFFFF;

//------------------------------------------------------------------------
//  
//------------------------------------------------------------------------
void main(void)
{
	WORD i;
//	WORD DacSample;
//	DWORD FifoOverflowFlag, FifoSize, MaxFifoBytesUsed;
//	double FifoMaxPercentLoad;
//	DWORD x, y;

	//      
	IsReadThreadComplete = false;
	//       
	ReadBuffer = NULL;
	//      
	hReadThread = NULL;
	//     :(
	hFile = INVALID_HANDLE_VALUE;
	//      
	ReadThreadErrorNumber = 0x0;

	//   	
	system("cls");

	printf(" *******************************\n");
	printf(" Module E-154                   \n");
	printf(" Console example for ADC Stream \n");
	printf(" *******************************\n\n");

	//     Lusbapi.dll
	if((DllVersion = GetDllVersion()) != CURRENT_VERSION_LUSBAPI)
	{
		char String[128];
		sprintf(String, " Lusbapi.dll Version Error!!!\n   Current: %1u.%1u. Required: %1u.%1u",
											DllVersion >> 0x10, DllVersion & 0xFFFF,
											CURRENT_VERSION_LUSBAPI >> 0x10, CURRENT_VERSION_LUSBAPI & 0xFFFF);

		AbortProgram(String);
	}
	else printf(" Lusbapi.dll Version --> OK\n");

	//     
	pModule = static_cast<ILE154 *>(CreateLInstance("e154"));
	if(!pModule) AbortProgram(" Module Interface --> Bad\n");
	else printf(" Module Interface --> OK\n");

	//    E-154   256  
	for(i = 0x0; i < MaxVirtualSoltsQuantity; i++) if(pModule->OpenLDevice(i)) break;
	// - ?
	if(i == MaxVirtualSoltsQuantity) AbortProgram(" Can't find any module E-154 in first 127 virtual slots!\n");
	else printf(" OpenLDevice(%u) --> OK\n", i);

	//    
	ModuleHandle = pModule->GetModuleHandle();
	if(ModuleHandle == INVALID_HANDLE_VALUE) AbortProgram(" GetModuleHandle() --> Bad\n");
	else printf(" GetModuleHandle() --> OK\n");

	//       
	if(!pModule->GetModuleName(ModuleName)) AbortProgram(" GetModuleName() --> Bad\n");
	else printf(" GetModuleName() --> OK\n");
	// ,   'E-154'
	if(strcmp(ModuleName, "E154")) AbortProgram(" The module is not 'E-154'\n");
	else printf(" The module is 'E-154'\n");

	//      USB
	if(!pModule->GetUsbSpeed(&UsbSpeed)) AbortProgram(" GetUsbSpeed() --> Bad\n");
	else printf(" GetUsbSpeed() --> OK\n");
	//      USB
	printf("   USB is in %s\n", UsbSpeed ? "High-Speed Mode (480 Mbit/s)" : "Full-Speed Mode (12 Mbit/s)");

	//     
	if(!pModule->GET_MODULE_DESCRIPTION(&ModuleDescription)) AbortProgram(" GET_MODULE_DESCRIPTION() --> Bad\n");
	else printf(" GET_MODULE_DESCRIPTION() --> OK\n");

	//     
	if(!pModule->GET_ADC_PARS(&ap)) AbortProgram(" GET_ADC_PARS() --> Bad\n");
	else printf(" GET_ADC_PARS() --> OK\n");
	//     
	ap.ClkSource = INT_ADC_CLOCK_E154;							//   
	ap.EnableClkOutput = ADC_CLOCK_TRANS_DISABLED_E154; 	//     
	ap.InputMode = NO_SYNC_E154;									//    
	ap.ChannelsQuantity = CHANNELS_QUANTITY; 					// -  
	//    
	for(i = 0x0; i < ap.ChannelsQuantity; i++) ap.ControlTable[i] = (WORD)(i | (ADC_INPUT_RANGE_5000mV_E154 << 0x6));
	ap.AdcRate = AdcRate;								//     
	ap.InterKadrDelay = 0.0;							//    
	//       
	if(!pModule->SET_ADC_PARS(&ap)) AbortProgram(" SET_ADC_PARS() --> Bad\n");
	else printf(" SET_ADC_PARS() --> OK\n");

	//    
	ReadBuffer = new SHORT[2*DataStep];
	if(!ReadBuffer) AbortProgram(" Can not allocate memory\n");

	//        
	hFile = CreateFile("Test.dat", GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
		FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN | FILE_FLAG_WRITE_THROUGH, NULL);
	if(hFile == INVALID_HANDLE_VALUE) AbortProgram("\n Can't create file 'Test.dat'!\n");

	//      
	printf(" \n");
    IsThreadStopping=false;
	hReadThread = CreateThread(0, 0x2000, ServiceReadThread, 0, 0, &ReadTid);
	if(!hReadThread) AbortProgram(" ServiceReadThread() --> Bad\n");
	else printf(" ServiceReadThread() --> OK\n");

	//        
	printf(" \n");
	printf(" Module E-154 (S/N %s) is ready ... \n", ModuleDescription.Module.SerialNumber);
	printf("   Module Info:\n");
	printf("     Module  Revision   is '%c'\n", ModuleDescription.Module.Revision);
	printf("     MCU Driver Version is %s (%s)\n", ModuleDescription.Mcu.Version.Version, ModuleDescription.Mcu.Version.Date);
	printf("   Adc parameters:\n");
	printf("     ChannelsQuantity = %2d\n", ap.ChannelsQuantity);
	printf("     AdcRate = %8.3f kHz\n", ap.AdcRate);
	printf("     InterKadrDelay = %2.4f ms\n", ap.InterKadrDelay);
	printf("     KadrRate = %8.3f kHz\n", ap.KadrRate);

	//         
	printf("\n Press any key if you want to terminate this program...\n\n");
	while(!IsReadThreadComplete)
	{
		if(OldCounter != Counter) { printf(" Counter %3u from %3u\r", Counter, NDataBlock); OldCounter = Counter; }
		else Sleep(20);
	}

	//      
	WaitForSingleObject(hReadThread, INFINITE);

	if(!pModule->STOP_ADC()) AbortProgram("  STOP_ADC()");

	//        
	printf("\n\n");
	if(ReadThreadErrorNumber) { AbortProgram(NULL, false); ShowThreadErrorMessage(); }
	else AbortProgram(" The program was completed successfully!!!\n", false);
}

//------------------------------------------------------------------------
// ,     
//------------------------------------------------------------------------
DWORD WINAPI ServiceReadThread(PVOID /*Context*/)
{
	WORD i;
	WORD RequestNumber;
	DWORD FileBytesWritten;
	//  OVERLAPPED    
	OVERLAPPED ReadOv[2];
	//       / 
	IO_REQUEST_LUSBAPI IoReq[2];

	//       USB-  
	if(!pModule->STOP_ADC()) { ReadThreadErrorNumber = 0x1; IsReadThreadComplete = true; return 0x0; }

	//      
	for(i = 0x0; i < 0x2; i++)
	{
		//    OVERLAPPED
		ZeroMemory(&ReadOv[i], sizeof(OVERLAPPED));
		//     
		ReadOv[i].hEvent = CreateEvent(NULL, FALSE , FALSE, NULL);
		//   IoReq
		IoReq[i].Buffer = ReadBuffer + i*DataStep;
		IoReq[i].NumberOfWordsToPass = DataStep;
		IoReq[i].NumberOfWordsPassed = 0x0;
		IoReq[i].Overlapped = &ReadOv[i];
		IoReq[i].TimeOut = (DWORD)(DataStep/ap.AdcRate + 1000);
	}

	//      
	RequestNumber = 0x0;
	if(!pModule->ReadData(&IoReq[RequestNumber])) { CloseHandle(ReadOv[0].hEvent); CloseHandle(ReadOv[1].hEvent); ReadThreadErrorNumber = 0x2; IsReadThreadComplete = true; return 0x0; }

	//  
	if(pModule->START_ADC())
	{
		//   
		for(i = 0x1; i < NDataBlock; i++)
		{
			//      
			RequestNumber ^= 0x1;
			if(!pModule->ReadData(&IoReq[RequestNumber])) { ReadThreadErrorNumber = 0x2; break; }
			if(ReadThreadErrorNumber) break;

			//       
			if(!WaitingForRequestCompleted(IoReq[RequestNumber^0x1].Overlapped)) break;
//			if(WaitForSingleObject(ReadOv[RequestNumber^0x1].hEvent, IoReq[RequestNumber^0x1].TimeOut) == WAIT_TIMEOUT) { ReadThreadErrorNumber = 0x3; break; }
			if(ReadThreadErrorNumber) break;

			//      
			if(!WriteFile(	hFile,													// handle to file to write to
		    					IoReq[RequestNumber^0x1].Buffer,					// pointer to data to write to file
								2*DataStep,	 											// number of bytes to write
	    						&FileBytesWritten,									// pointer to number of bytes written
						   	NULL			  											// pointer to structure needed for overlapped I/O
							   )) { ReadThreadErrorNumber = 0x4; break; }

			if(ReadThreadErrorNumber) break;
			else if(kbhit()) { ReadThreadErrorNumber = 0x5; break; }
			else Sleep(20);
			Counter++;
		}

      IsThreadStopping=true;

	   //   
		if(!ReadThreadErrorNumber)
		{
			RequestNumber ^= 0x1;
			//       
			if(!WaitingForRequestCompleted(IoReq[RequestNumber^0x1].Overlapped)) ReadThreadErrorNumber = 0x3;
//			if(WaitForSingleObject(ReadOv[RequestNumber^0x1].hEvent, IoReq[RequestNumber^0x1].TimeOut) == WAIT_TIMEOUT) ReadThreadErrorNumber = 0x3;
			//      
			if(!WriteFile(	hFile,													// handle to file to write to
		    					IoReq[RequestNumber^0x1].Buffer,					// pointer to data to write to file
								2*DataStep,	 											// number of bytes to write
	    						&FileBytesWritten,									// pointer to number of bytes written
						   	NULL			  											// pointer to structure needed for overlapped I/O
							   )) ReadThreadErrorNumber = 0x4;
			Counter++;
		}
	}
	else { ReadThreadErrorNumber = 0x6; }

	//        
	if(!CancelIo(ModuleHandle)) { ReadThreadErrorNumber = 0x7; }
	//    
	for(i = 0x0; i < 0x2; i++) CloseHandle(ReadOv[i].hEvent);
	//  
	Sleep(100);
	//       
	IsReadThreadComplete = true;
	//      
	return 0x0;
}

//---------------------------------------------------------------------------
//
//---------------------------------------------------------------------------
BOOL WaitingForRequestCompleted(OVERLAPPED *ReadOv)
{
	DWORD ReadBytesTransferred;

	while(TRUE)
	{
		if(GetOverlappedResult(ModuleHandle, ReadOv, &ReadBytesTransferred, FALSE)) break;
		else if(GetLastError() !=  ERROR_IO_INCOMPLETE) { ReadThreadErrorNumber = 0x3; return FALSE; }
		else if(kbhit()) { ReadThreadErrorNumber = 0x5; return FALSE; }
		else Sleep(20);
	}
	return TRUE;
}

//------------------------------------------------------------------------
//    
//------------------------------------------------------------------------
void ShowThreadErrorMessage(void)
{
	switch(ReadThreadErrorNumber)
	{
		case 0x1:
			printf(" ADC Thread: STOP_ADC() --> Bad\n");
			break;

		case 0x2:
			printf(" ADC Thread: ReadData() --> Bad\n");
			break;

		case 0x3:
			printf(" ADC Thread: Timeout is occured!\n");
			break;

		case 0x4:
			printf(" ADC Thread: Writing data file error!\n");
			break;

		case 0x5:
			//     ,   
			printf(" ADC Thread: The program was terminated!\n");
			break;

		case 0x6:
			printf(" ADC Thread: START_ADC() --> Bad\n");
			break;

		case 0x7:
			printf(" ADC Thread: Can't cancel ending input and output (I/O) operations!\n");
			break;

		default:
			printf(" Unknown error!\n");
			break;
	}

	return;
}

//------------------------------------------------------------------------
//   
//------------------------------------------------------------------------
void AbortProgram(char *ErrorString, bool AbortionFlag)
{
	//   
	if(pModule)
	{
		//   
		if(!pModule->ReleaseLInstance()) printf(" ReleaseLInstance() --> Bad\n");
		else printf(" ReleaseLInstance() --> OK\n");
		//     
		pModule = NULL;
	}

	//   
	if(ReadBuffer) { delete[] ReadBuffer; ReadBuffer = NULL; }
	//     
	if(hReadThread) { CloseHandle(hReadThread); hReadThread = NULL; }
	//    
	if(hFile != INVALID_HANDLE_VALUE) { CloseHandle(hFile); hFile = INVALID_HANDLE_VALUE; }

	//   
	if(ErrorString) printf(ErrorString);

	//   
	if(kbhit()) { while(kbhit()) getch(); }

	//   -   
	if(AbortionFlag) exit(0x1);
	//        
	else return;
}

